/* 
 * File:   init.c
 * Author: LaV
 * Comments:
 * Revision history: 1
 */
#include "init.h"

void init(void){ 
//========================PORTS=================================================
//PORTA-------------------------------------------------------------------------    
    ADCON0bits.ADON = 0;//АЦП выключен
    ADCON1 = 0b00000111;//PORTA цифровой вход
    TRISAbits.RA0 = 1;//Door1
    TRISAbits.RA1 = 1;//Exit1
    TRISAbits.RA2 = 1;//Door2
//PORTB-------------------------------------------------------------------------  
    TRISB = 0b00001111;   
    PORTB = 0b00000000;   
    PORTBbits.RB5 = 1;//K2 по умолчанию замкнуто
    PORTBbits.RB6 = 1;//Red-Led Reader2 по умолчанию
//PORTC-------------------------------------------------------------------------    
    TRISC = 0b0000000;
    TRISCbits.RC3 = 1;//SCL
    TRISCbits.RC4 = 1;//SDA
    TRISCbits.RC5 = 0;//R/T
    TRISCbits.RC6 = 0;//TX
    TRISCbits.RC7 = 1;//RX 
    //PORTC = 0b00000000;
    PORTCbits.RC0 = 1;
    PORTCbits.RC5 = 0;
    
//PORTD-------------------------------------------------------------------------    
    TRISD = 0b10000000;//RD1 на вход (тампер), остальные на выход
    PORTD = 0b00000000;
    PORTDbits.RD6 = 1;//K1 по умолчанию замкнуто
    PORTDbits.RD0 = 0;
    PORTDbits.RD2 = 1;
    PORTDbits.RD3 = 1;//Red-Led Reader1 по умолчанию    
//PORTE-------------------------------------------------------------------------    
    TRISEbits.RE0 = 1;//Exit2    
//===========================Interrupts=========================================    
    GIE = 1;//глобальное разрешение прерывание
    IPEN = 1;//приоритетная системма прерываний
    GIEH = 1;//прерывания с высоким приоритетом
    GIEL = 1;//прерывания с высоким приоритетом
    PEIE = 1;//периферийные прерывания
    //SSPIE = 1;//SSP прерывания
//INT0,INT1,INT2(INTCON2)-------------------------------------------------------
    INT1IP = 1;//высокий приоритет INT1  
    INT2IP = 1;//высокий приоритет INT2 
           
    INTEDG0 = 0;//прерывание по заднему фронту
    INTEDG1 = 0;
    INTEDG2 = 0;
        
    INT0IF = 0;//сброс флага прерывания от INT0
    INT1IF = 0; 
    INT2IF = 0;
        
    INT0IE = 1;//разрешение прерывания от INT0(RB0)
    INT1IE = 1;//разрешение прерывания от INT1(RB1)
    INT2IE = 1;//разрешение прерывания от INT2(RB2)
//TMR1--------------------------------------------------------------------------        
    TMR1IE = 1;//разрешить прерывания от TMR1
    TMR1IP = 0;//приоритет низкий
    TMR1CS = 0;//Internal clock (Fosc/4))
    T1CKPS0 = 1;//Предделитель 1:8
    T1CKPS1 = 1;
    TMR1 = 0x0000;//обнуление, счет от 0 до 65535
    TMR1IF = 0;//обнуление флага
    TMR1ON = 1;//активация таймера
//===========================I2C================================================
//SSPCON1-----------------------------------------------------------------------
    //SSPCON1bits.SSPEN = 1;//активация модуля MSSP
    //SSPCON1bits.SSPM3 = 1;//аппаратный режим ведущего I2C
    //SSPCON1 = 0b00101000;//  
    SSPCON1 = 0x28;
//SSPCON2-----------------------------------------------------------------------    
    SSPCON2 = 0b00000000;
//SSPSTAT-----------------------------------------------------------------------    
    //SSPSTATbits.SMP = 1;//управление длительностью фронта (100кГц или 1МгЦ)
    //SSPSTAT = 0b10000000;
    SSPSTAT = 0x80;
    
    SSPADD = ((_XTAL_FREQ/1000000)/4)-1;//установка битрейта
    //SSPADD = 0x4;//((Fosc/BitRate)/4)-1 = ((8MHz/1000kHz)/4)-1 = 0x1;
    DDRCbits.RC4 = 1;//SDA
    DDRCbits.RC3 = 1;//SCL
    ACKSTAT=0;//Bit error answer
    WCOL = 0;//Bit collision
    
    //SSPIE = 1;//Разрешены прерывания SSP-модуля.
    //SSPIF = 0;//Флаг прерываний SSP-модуля
//===========================CCP2===============================================
    CCP2IE = 1;//Разрешены прерывания CCP2-модуля
    CCP2IF = 0;//Флаг прерываний CCP2-модуля
    CCP2IP = 1;//Bысокий приоритет
    //CCP2MUX = 0; RB3 соединен с CCP2  
    CCP2CON = 0;//начальный сброс
    CCP2CON = 0b00000100; 
    CCP2CONbits.CCP2M2 = 1;//захват по каждому заднему фронту
   
//------------------------------------------------------------------------------
//===========================USART==============================================
    RCIP = 1;//Высокий приоритет прерываний премника USART     
    RCIF = 0;//Флаг приемника (буфер пуст)
    RCIE = 1;//Разрешены прерывания от приемника USART
    
    TXIP = 0;//Низкий приоритет прерываний передатчика USART     
    TXIF = 1;//Флаг передатчика (буфер пуст)
    //TXIE = 1;//Разрешены прерывания от передатчика USART
    
    TXSTA = 0;
    //TXEN = 1;//Передача разрешена
    SYNC = 0;//Асинхронный режим
    TX9 = 0;//8-рязрядная передача
    BRGH = 0;//Низкоскоростной режим
    //SPBRG = 0x19;//((8000000/9600)/64)-1
    SPBRG = ((_XTAL_FREQ/9600)/64)-1;
    SPEN = 1;//USART включен
    
    //RCSTA = 0;
    //SPEN = 1;//USART включен
    RX9 = 0;//8-ми разрядный прием
    SREN = 1;//разрешен одиночный прием
    CREN = 1;//Прием разрешен  
//------------------------------------------------------------------------------    
}
